package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AccountTeam private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  accountId: Output[String],
  createTime: Output[String],
  name: Output[String],
  teamId: Output[String],
  updateTime: Output[String]
) extends CustomResource derives ResourceDecoder

object AccountTeam:
  given outputOps: {} with
    extension(output: Output[AccountTeam])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def accountId: Output[String] = output.flatMap(_.accountId)
      def createTime: Output[String] = output.flatMap(_.createTime)
      def name: Output[String] = output.flatMap(_.name)
      def teamId: Output[String] = output.flatMap(_.teamId)
      def updateTime: Output[String] = output.flatMap(_.updateTime)

def accountTeam(using ctx: Context)(
  name: NonEmptyString,
  args: AccountTeamArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AccountTeam] = 
  ctx.registerResource[AccountTeam, AccountTeamArgs]("aiven:index/accountTeam:AccountTeam", name, args, opts)

