package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AccountTeamArgs private(
  accountId: Output[String],
  name: Output[Option[String]]
) derives ArgsEncoder

object AccountTeamArgs:
  def apply(
    accountId: Input[String],
    name: Input.Optional[String] = None
  )(using Context): AccountTeamArgs =
    new AccountTeamArgs(
      accountId = accountId.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false)
    )
