package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AccountTeamMember private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  accepted: Output[Boolean],
  accountId: Output[String],
  createTime: Output[String],
  invitedByUserEmail: Output[String],
  teamId: Output[String],
  userEmail: Output[String]
) extends CustomResource derives ResourceDecoder

object AccountTeamMember:
  given outputOps: {} with
    extension(output: Output[AccountTeamMember])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def accepted: Output[Boolean] = output.flatMap(_.accepted)
      def accountId: Output[String] = output.flatMap(_.accountId)
      def createTime: Output[String] = output.flatMap(_.createTime)
      def invitedByUserEmail: Output[String] = output.flatMap(_.invitedByUserEmail)
      def teamId: Output[String] = output.flatMap(_.teamId)
      def userEmail: Output[String] = output.flatMap(_.userEmail)

def accountTeamMember(using ctx: Context)(
  name: NonEmptyString,
  args: AccountTeamMemberArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AccountTeamMember] = 
  ctx.registerResource[AccountTeamMember, AccountTeamMemberArgs]("aiven:index/accountTeamMember:AccountTeamMember", name, args, opts)

