package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AccountTeamMemberArgs private(
  accountId: Output[String],
  teamId: Output[String],
  userEmail: Output[String]
) derives ArgsEncoder

object AccountTeamMemberArgs:
  def apply(
    accountId: Input[String],
    teamId: Input[String],
    userEmail: Input[String]
  )(using Context): AccountTeamMemberArgs =
    new AccountTeamMemberArgs(
      accountId = accountId.asOutput(isSecret = false),
      teamId = teamId.asOutput(isSecret = false),
      userEmail = userEmail.asOutput(isSecret = false)
    )
