package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AccountTeamProject private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  accountId: Output[String],
  projectName: Output[Option[String]],
  teamId: Output[String],
  teamType: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object AccountTeamProject:
  given outputOps: {} with
    extension(output: Output[AccountTeamProject])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def accountId: Output[String] = output.flatMap(_.accountId)
      def projectName: Output[Option[String]] = output.flatMap(_.projectName)
      def teamId: Output[String] = output.flatMap(_.teamId)
      def teamType: Output[Option[String]] = output.flatMap(_.teamType)

def accountTeamProject(using ctx: Context)(
  name: NonEmptyString,
  args: AccountTeamProjectArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AccountTeamProject] = 
  ctx.registerResource[AccountTeamProject, AccountTeamProjectArgs]("aiven:index/accountTeamProject:AccountTeamProject", name, args, opts)

