package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AccountTeamProjectArgs private(
  accountId: Output[String],
  projectName: Output[Option[String]],
  teamId: Output[String],
  teamType: Output[Option[String]]
) derives ArgsEncoder

object AccountTeamProjectArgs:
  def apply(
    accountId: Input[String],
    projectName: Input.Optional[String] = None,
    teamId: Input[String],
    teamType: Input.Optional[String] = None
  )(using Context): AccountTeamProjectArgs =
    new AccountTeamProjectArgs(
      accountId = accountId.asOutput(isSecret = false),
      projectName = projectName.asOptionOutput(isSecret = false),
      teamId = teamId.asOutput(isSecret = false),
      teamType = teamType.asOptionOutput(isSecret = false)
    )
