package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AwsPrivatelink private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  awsServiceId: Output[String],
  awsServiceName: Output[String],
  principals: Output[scala.collection.immutable.List[String]],
  project: Output[String],
  serviceName: Output[String]
) extends CustomResource derives ResourceDecoder

object AwsPrivatelink:
  given outputOps: {} with
    extension(output: Output[AwsPrivatelink])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def awsServiceId: Output[String] = output.flatMap(_.awsServiceId)
      def awsServiceName: Output[String] = output.flatMap(_.awsServiceName)
      def principals: Output[scala.collection.immutable.List[String]] = output.flatMap(_.principals)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)

def awsPrivatelink(using ctx: Context)(
  name: NonEmptyString,
  args: AwsPrivatelinkArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AwsPrivatelink] = 
  ctx.registerResource[AwsPrivatelink, AwsPrivatelinkArgs]("aiven:index/awsPrivatelink:AwsPrivatelink", name, args, opts)

