package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AwsPrivatelinkArgs private(
  principals: Output[scala.collection.immutable.List[String]],
  project: Output[String],
  serviceName: Output[String]
) derives ArgsEncoder

object AwsPrivatelinkArgs:
  def apply(
    principals: Input[List[Input[String]]],
    project: Input[String],
    serviceName: Input[String]
  )(using Context): AwsPrivatelinkArgs =
    new AwsPrivatelinkArgs(
      principals = principals.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false)
    )
