package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AwsVpcPeeringConnection private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  awsAccountId: Output[String],
  awsVpcId: Output[String],
  awsVpcPeeringConnectionId: Output[String],
  awsVpcRegion: Output[String],
  state: Output[String],
  stateInfo: Output[scala.Predef.Map[String, besom.types.PulumiAny]],
  vpcId: Output[String]
) extends CustomResource derives ResourceDecoder

object AwsVpcPeeringConnection:
  given outputOps: {} with
    extension(output: Output[AwsVpcPeeringConnection])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def awsAccountId: Output[String] = output.flatMap(_.awsAccountId)
      def awsVpcId: Output[String] = output.flatMap(_.awsVpcId)
      def awsVpcPeeringConnectionId: Output[String] = output.flatMap(_.awsVpcPeeringConnectionId)
      def awsVpcRegion: Output[String] = output.flatMap(_.awsVpcRegion)
      def state: Output[String] = output.flatMap(_.state)
      def stateInfo: Output[scala.Predef.Map[String, besom.types.PulumiAny]] = output.flatMap(_.stateInfo)
      def vpcId: Output[String] = output.flatMap(_.vpcId)

def awsVpcPeeringConnection(using ctx: Context)(
  name: NonEmptyString,
  args: AwsVpcPeeringConnectionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AwsVpcPeeringConnection] = 
  ctx.registerResource[AwsVpcPeeringConnection, AwsVpcPeeringConnectionArgs]("aiven:index/awsVpcPeeringConnection:AwsVpcPeeringConnection", name, args, opts)

