package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AwsVpcPeeringConnectionArgs private(
  awsAccountId: Output[String],
  awsVpcId: Output[String],
  awsVpcRegion: Output[String],
  vpcId: Output[String]
) derives ArgsEncoder

object AwsVpcPeeringConnectionArgs:
  def apply(
    awsAccountId: Input[String],
    awsVpcId: Input[String],
    awsVpcRegion: Input[String],
    vpcId: Input[String]
  )(using Context): AwsVpcPeeringConnectionArgs =
    new AwsVpcPeeringConnectionArgs(
      awsAccountId = awsAccountId.asOutput(isSecret = false),
      awsVpcId = awsVpcId.asOutput(isSecret = false),
      awsVpcRegion = awsVpcRegion.asOutput(isSecret = false),
      vpcId = vpcId.asOutput(isSecret = false)
    )
