package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AzurePrivatelink private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  azureServiceAlias: Output[String],
  azureServiceId: Output[String],
  message: Output[String],
  project: Output[String],
  serviceName: Output[String],
  state: Output[String],
  userSubscriptionIds: Output[scala.collection.immutable.List[String]]
) extends CustomResource derives ResourceDecoder

object AzurePrivatelink:
  given outputOps: {} with
    extension(output: Output[AzurePrivatelink])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def azureServiceAlias: Output[String] = output.flatMap(_.azureServiceAlias)
      def azureServiceId: Output[String] = output.flatMap(_.azureServiceId)
      def message: Output[String] = output.flatMap(_.message)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def state: Output[String] = output.flatMap(_.state)
      def userSubscriptionIds: Output[scala.collection.immutable.List[String]] = output.flatMap(_.userSubscriptionIds)

def azurePrivatelink(using ctx: Context)(
  name: NonEmptyString,
  args: AzurePrivatelinkArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AzurePrivatelink] = 
  ctx.registerResource[AzurePrivatelink, AzurePrivatelinkArgs]("aiven:index/azurePrivatelink:AzurePrivatelink", name, args, opts)

