package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AzurePrivatelinkArgs private(
  project: Output[String],
  serviceName: Output[String],
  userSubscriptionIds: Output[scala.collection.immutable.List[String]]
) derives ArgsEncoder

object AzurePrivatelinkArgs:
  def apply(
    project: Input[String],
    serviceName: Input[String],
    userSubscriptionIds: Input[List[Input[String]]]
  )(using Context): AzurePrivatelinkArgs =
    new AzurePrivatelinkArgs(
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      userSubscriptionIds = userSubscriptionIds.asOutput(isSecret = false)
    )
