package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AzurePrivatelinkConnectionApproval private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  endpointIpAddress: Output[Option[String]],
  privatelinkConnectionId: Output[String],
  project: Output[String],
  serviceName: Output[String],
  state: Output[String]
) extends CustomResource derives ResourceDecoder

object AzurePrivatelinkConnectionApproval:
  given outputOps: {} with
    extension(output: Output[AzurePrivatelinkConnectionApproval])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def endpointIpAddress: Output[Option[String]] = output.flatMap(_.endpointIpAddress)
      def privatelinkConnectionId: Output[String] = output.flatMap(_.privatelinkConnectionId)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def state: Output[String] = output.flatMap(_.state)

def azurePrivatelinkConnectionApproval(using ctx: Context)(
  name: NonEmptyString,
  args: AzurePrivatelinkConnectionApprovalArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AzurePrivatelinkConnectionApproval] = 
  ctx.registerResource[AzurePrivatelinkConnectionApproval, AzurePrivatelinkConnectionApprovalArgs]("aiven:index/azurePrivatelinkConnectionApproval:AzurePrivatelinkConnectionApproval", name, args, opts)

