package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AzurePrivatelinkConnectionApprovalArgs private(
  endpointIpAddress: Output[Option[String]],
  project: Output[String],
  serviceName: Output[String]
) derives ArgsEncoder

object AzurePrivatelinkConnectionApprovalArgs:
  def apply(
    endpointIpAddress: Input.Optional[String] = None,
    project: Input[String],
    serviceName: Input[String]
  )(using Context): AzurePrivatelinkConnectionApprovalArgs =
    new AzurePrivatelinkConnectionApprovalArgs(
      endpointIpAddress = endpointIpAddress.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false)
    )
