package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AzureVpcPeeringConnection private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  azureSubscriptionId: Output[String],
  peerAzureAppId: Output[String],
  peerAzureTenantId: Output[String],
  peerResourceGroup: Output[String],
  peeringConnectionId: Output[String],
  state: Output[String],
  stateInfo: Output[scala.Predef.Map[String, besom.types.PulumiAny]],
  vnetName: Output[String],
  vpcId: Output[String]
) extends CustomResource derives ResourceDecoder

object AzureVpcPeeringConnection:
  given outputOps: {} with
    extension(output: Output[AzureVpcPeeringConnection])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def azureSubscriptionId: Output[String] = output.flatMap(_.azureSubscriptionId)
      def peerAzureAppId: Output[String] = output.flatMap(_.peerAzureAppId)
      def peerAzureTenantId: Output[String] = output.flatMap(_.peerAzureTenantId)
      def peerResourceGroup: Output[String] = output.flatMap(_.peerResourceGroup)
      def peeringConnectionId: Output[String] = output.flatMap(_.peeringConnectionId)
      def state: Output[String] = output.flatMap(_.state)
      def stateInfo: Output[scala.Predef.Map[String, besom.types.PulumiAny]] = output.flatMap(_.stateInfo)
      def vnetName: Output[String] = output.flatMap(_.vnetName)
      def vpcId: Output[String] = output.flatMap(_.vpcId)

def azureVpcPeeringConnection(using ctx: Context)(
  name: NonEmptyString,
  args: AzureVpcPeeringConnectionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AzureVpcPeeringConnection] = 
  ctx.registerResource[AzureVpcPeeringConnection, AzureVpcPeeringConnectionArgs]("aiven:index/azureVpcPeeringConnection:AzureVpcPeeringConnection", name, args, opts)

