package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AzureVpcPeeringConnectionArgs private(
  azureSubscriptionId: Output[String],
  peerAzureAppId: Output[String],
  peerAzureTenantId: Output[String],
  peerResourceGroup: Output[String],
  vnetName: Output[String],
  vpcId: Output[String]
) derives ArgsEncoder

object AzureVpcPeeringConnectionArgs:
  def apply(
    azureSubscriptionId: Input[String],
    peerAzureAppId: Input[String],
    peerAzureTenantId: Input[String],
    peerResourceGroup: Input[String],
    vnetName: Input[String],
    vpcId: Input[String]
  )(using Context): AzureVpcPeeringConnectionArgs =
    new AzureVpcPeeringConnectionArgs(
      azureSubscriptionId = azureSubscriptionId.asOutput(isSecret = false),
      peerAzureAppId = peerAzureAppId.asOutput(isSecret = false),
      peerAzureTenantId = peerAzureTenantId.asOutput(isSecret = false),
      peerResourceGroup = peerResourceGroup.asOutput(isSecret = false),
      vnetName = vnetName.asOutput(isSecret = false),
      vpcId = vpcId.asOutput(isSecret = false)
    )
