package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BillingGroup private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  accountId: Output[Option[String]],
  addressLines: Output[Option[scala.collection.immutable.List[String]]],
  billingCurrency: Output[Option[String]],
  billingEmails: Output[Option[scala.collection.immutable.List[String]]],
  billingExtraText: Output[Option[String]],
  cardId: Output[Option[String]],
  city: Output[Option[String]],
  company: Output[Option[String]],
  copyFromBillingGroup: Output[Option[String]],
  countryCode: Output[Option[String]],
  name: Output[String],
  parentId: Output[Option[String]],
  state: Output[Option[String]],
  vatId: Output[Option[String]],
  zipCode: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object BillingGroup:
  given outputOps: {} with
    extension(output: Output[BillingGroup])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def accountId: Output[Option[String]] = output.flatMap(_.accountId)
      def addressLines: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.addressLines)
      def billingCurrency: Output[Option[String]] = output.flatMap(_.billingCurrency)
      def billingEmails: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.billingEmails)
      def billingExtraText: Output[Option[String]] = output.flatMap(_.billingExtraText)
      def cardId: Output[Option[String]] = output.flatMap(_.cardId)
      def city: Output[Option[String]] = output.flatMap(_.city)
      def company: Output[Option[String]] = output.flatMap(_.company)
      def copyFromBillingGroup: Output[Option[String]] = output.flatMap(_.copyFromBillingGroup)
      def countryCode: Output[Option[String]] = output.flatMap(_.countryCode)
      def name: Output[String] = output.flatMap(_.name)
      def parentId: Output[Option[String]] = output.flatMap(_.parentId)
      def state: Output[Option[String]] = output.flatMap(_.state)
      def vatId: Output[Option[String]] = output.flatMap(_.vatId)
      def zipCode: Output[Option[String]] = output.flatMap(_.zipCode)

def billingGroup(using ctx: Context)(
  name: NonEmptyString,
  args: BillingGroupArgs = BillingGroupArgs(),
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BillingGroup] = 
  ctx.registerResource[BillingGroup, BillingGroupArgs]("aiven:index/billingGroup:BillingGroup", name, args, opts)

