package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BillingGroupArgs private(
  accountId: Output[Option[String]],
  addressLines: Output[Option[scala.collection.immutable.List[String]]],
  billingCurrency: Output[Option[String]],
  billingEmails: Output[Option[scala.collection.immutable.List[String]]],
  billingExtraText: Output[Option[String]],
  cardId: Output[Option[String]],
  city: Output[Option[String]],
  company: Output[Option[String]],
  copyFromBillingGroup: Output[Option[String]],
  countryCode: Output[Option[String]],
  name: Output[Option[String]],
  parentId: Output[Option[String]],
  state: Output[Option[String]],
  vatId: Output[Option[String]],
  zipCode: Output[Option[String]]
) derives ArgsEncoder

object BillingGroupArgs:
  def apply(
    accountId: Input.Optional[String] = None,
    addressLines: Input.Optional[List[Input[String]]] = None,
    billingCurrency: Input.Optional[String] = None,
    billingEmails: Input.Optional[List[Input[String]]] = None,
    billingExtraText: Input.Optional[String] = None,
    cardId: Input.Optional[String] = None,
    city: Input.Optional[String] = None,
    company: Input.Optional[String] = None,
    copyFromBillingGroup: Input.Optional[String] = None,
    countryCode: Input.Optional[String] = None,
    name: Input.Optional[String] = None,
    parentId: Input.Optional[String] = None,
    state: Input.Optional[String] = None,
    vatId: Input.Optional[String] = None,
    zipCode: Input.Optional[String] = None
  )(using Context): BillingGroupArgs =
    new BillingGroupArgs(
      accountId = accountId.asOptionOutput(isSecret = false),
      addressLines = addressLines.asOptionOutput(isSecret = false),
      billingCurrency = billingCurrency.asOptionOutput(isSecret = false),
      billingEmails = billingEmails.asOptionOutput(isSecret = false),
      billingExtraText = billingExtraText.asOptionOutput(isSecret = false),
      cardId = cardId.asOptionOutput(isSecret = false),
      city = city.asOptionOutput(isSecret = false),
      company = company.asOptionOutput(isSecret = false),
      copyFromBillingGroup = copyFromBillingGroup.asOptionOutput(isSecret = false),
      countryCode = countryCode.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      parentId = parentId.asOptionOutput(isSecret = false),
      state = state.asOptionOutput(isSecret = false),
      vatId = vatId.asOptionOutput(isSecret = false),
      zipCode = zipCode.asOptionOutput(isSecret = false)
    )
