package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class Cassandra private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  additionalDiskSpace: Output[Option[String]],
  cassandraUserConfig: Output[Option[besom.api.aiven.outputs.CassandraCassandraUserConfig]],
  cassandras: Output[scala.collection.immutable.List[besom.api.aiven.outputs.CassandraCassandra]],
  cloudName: Output[Option[String]],
  components: Output[scala.collection.immutable.List[besom.api.aiven.outputs.CassandraComponent]],
  diskSpace: Output[Option[String]],
  diskSpaceCap: Output[String],
  diskSpaceDefault: Output[String],
  diskSpaceStep: Output[String],
  diskSpaceUsed: Output[String],
  maintenanceWindowDow: Output[Option[String]],
  maintenanceWindowTime: Output[Option[String]],
  plan: Output[String],
  project: Output[String],
  projectVpcId: Output[Option[String]],
  serviceHost: Output[String],
  serviceIntegrations: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.CassandraServiceIntegration]]],
  serviceName: Output[String],
  servicePassword: Output[String],
  servicePort: Output[Int],
  serviceType: Output[String],
  serviceUri: Output[String],
  serviceUsername: Output[String],
  state: Output[String],
  staticIps: Output[Option[scala.collection.immutable.List[String]]],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.CassandraTag]]],
  terminationProtection: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object Cassandra:
  given outputOps: {} with
    extension(output: Output[Cassandra])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def additionalDiskSpace: Output[Option[String]] = output.flatMap(_.additionalDiskSpace)
      def cassandraUserConfig: Output[Option[besom.api.aiven.outputs.CassandraCassandraUserConfig]] = output.flatMap(_.cassandraUserConfig)
      def cassandras: Output[scala.collection.immutable.List[besom.api.aiven.outputs.CassandraCassandra]] = output.flatMap(_.cassandras)
      def cloudName: Output[Option[String]] = output.flatMap(_.cloudName)
      def components: Output[scala.collection.immutable.List[besom.api.aiven.outputs.CassandraComponent]] = output.flatMap(_.components)
      def diskSpace: Output[Option[String]] = output.flatMap(_.diskSpace)
      def diskSpaceCap: Output[String] = output.flatMap(_.diskSpaceCap)
      def diskSpaceDefault: Output[String] = output.flatMap(_.diskSpaceDefault)
      def diskSpaceStep: Output[String] = output.flatMap(_.diskSpaceStep)
      def diskSpaceUsed: Output[String] = output.flatMap(_.diskSpaceUsed)
      def maintenanceWindowDow: Output[Option[String]] = output.flatMap(_.maintenanceWindowDow)
      def maintenanceWindowTime: Output[Option[String]] = output.flatMap(_.maintenanceWindowTime)
      def plan: Output[String] = output.flatMap(_.plan)
      def project: Output[String] = output.flatMap(_.project)
      def projectVpcId: Output[Option[String]] = output.flatMap(_.projectVpcId)
      def serviceHost: Output[String] = output.flatMap(_.serviceHost)
      def serviceIntegrations: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.CassandraServiceIntegration]]] = output.flatMap(_.serviceIntegrations)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def servicePassword: Output[String] = output.flatMap(_.servicePassword)
      def servicePort: Output[Int] = output.flatMap(_.servicePort)
      def serviceType: Output[String] = output.flatMap(_.serviceType)
      def serviceUri: Output[String] = output.flatMap(_.serviceUri)
      def serviceUsername: Output[String] = output.flatMap(_.serviceUsername)
      def state: Output[String] = output.flatMap(_.state)
      def staticIps: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.staticIps)
      def tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.CassandraTag]]] = output.flatMap(_.tags)
      def terminationProtection: Output[Option[Boolean]] = output.flatMap(_.terminationProtection)

def cassandra(using ctx: Context)(
  name: NonEmptyString,
  args: CassandraArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[Cassandra] = 
  ctx.registerResource[Cassandra, CassandraArgs]("aiven:index/cassandra:Cassandra", name, args, opts)

