package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class CassandraArgs private(
  additionalDiskSpace: Output[Option[String]],
  cassandraUserConfig: Output[Option[besom.api.aiven.inputs.CassandraCassandraUserConfigArgs]],
  cloudName: Output[Option[String]],
  diskSpace: Output[Option[String]],
  maintenanceWindowDow: Output[Option[String]],
  maintenanceWindowTime: Output[Option[String]],
  plan: Output[String],
  project: Output[String],
  projectVpcId: Output[Option[String]],
  serviceIntegrations: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.CassandraServiceIntegrationArgs]]],
  serviceName: Output[String],
  staticIps: Output[Option[scala.collection.immutable.List[String]]],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.CassandraTagArgs]]],
  terminationProtection: Output[Option[Boolean]]
) derives ArgsEncoder

object CassandraArgs:
  def apply(
    additionalDiskSpace: Input.Optional[String] = None,
    cassandraUserConfig: Input.Optional[besom.api.aiven.inputs.CassandraCassandraUserConfigArgs] = None,
    cloudName: Input.Optional[String] = None,
    diskSpace: Input.Optional[String] = None,
    maintenanceWindowDow: Input.Optional[String] = None,
    maintenanceWindowTime: Input.Optional[String] = None,
    plan: Input[String],
    project: Input[String],
    projectVpcId: Input.Optional[String] = None,
    serviceIntegrations: Input.Optional[List[Input[besom.api.aiven.inputs.CassandraServiceIntegrationArgs]]] = None,
    serviceName: Input[String],
    staticIps: Input.Optional[List[Input[String]]] = None,
    tags: Input.Optional[List[Input[besom.api.aiven.inputs.CassandraTagArgs]]] = None,
    terminationProtection: Input.Optional[Boolean] = None
  )(using Context): CassandraArgs =
    new CassandraArgs(
      additionalDiskSpace = additionalDiskSpace.asOptionOutput(isSecret = false),
      cassandraUserConfig = cassandraUserConfig.asOptionOutput(isSecret = false),
      cloudName = cloudName.asOptionOutput(isSecret = false),
      diskSpace = diskSpace.asOptionOutput(isSecret = false),
      maintenanceWindowDow = maintenanceWindowDow.asOptionOutput(isSecret = false),
      maintenanceWindowTime = maintenanceWindowTime.asOptionOutput(isSecret = false),
      plan = plan.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      projectVpcId = projectVpcId.asOptionOutput(isSecret = false),
      serviceIntegrations = serviceIntegrations.asOptionOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false),
      tags = tags.asOptionOutput(isSecret = false),
      terminationProtection = terminationProtection.asOptionOutput(isSecret = false)
    )
