package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class ClickhouseDatabase private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  name: Output[String],
  project: Output[String],
  serviceName: Output[String],
  terminationProtection: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object ClickhouseDatabase:
  given outputOps: {} with
    extension(output: Output[ClickhouseDatabase])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def name: Output[String] = output.flatMap(_.name)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def terminationProtection: Output[Option[Boolean]] = output.flatMap(_.terminationProtection)

def clickhouseDatabase(using ctx: Context)(
  name: NonEmptyString,
  args: ClickhouseDatabaseArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[ClickhouseDatabase] = 
  ctx.registerResource[ClickhouseDatabase, ClickhouseDatabaseArgs]("aiven:index/clickhouseDatabase:ClickhouseDatabase", name, args, opts)

