package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ClickhouseDatabaseArgs private(
  name: Output[Option[String]],
  project: Output[String],
  serviceName: Output[String],
  terminationProtection: Output[Option[Boolean]]
) derives ArgsEncoder

object ClickhouseDatabaseArgs:
  def apply(
    name: Input.Optional[String] = None,
    project: Input[String],
    serviceName: Input[String],
    terminationProtection: Input.Optional[Boolean] = None
  )(using Context): ClickhouseDatabaseArgs =
    new ClickhouseDatabaseArgs(
      name = name.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      terminationProtection = terminationProtection.asOptionOutput(isSecret = false)
    )
