package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class ClickhouseGrant private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  privilegeGrants: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.ClickhouseGrantPrivilegeGrant]]],
  project: Output[String],
  role: Output[Option[String]],
  roleGrants: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.ClickhouseGrantRoleGrant]]],
  serviceName: Output[String],
  user: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object ClickhouseGrant:
  given outputOps: {} with
    extension(output: Output[ClickhouseGrant])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def privilegeGrants: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.ClickhouseGrantPrivilegeGrant]]] = output.flatMap(_.privilegeGrants)
      def project: Output[String] = output.flatMap(_.project)
      def role: Output[Option[String]] = output.flatMap(_.role)
      def roleGrants: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.ClickhouseGrantRoleGrant]]] = output.flatMap(_.roleGrants)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def user: Output[Option[String]] = output.flatMap(_.user)

def clickhouseGrant(using ctx: Context)(
  name: NonEmptyString,
  args: ClickhouseGrantArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[ClickhouseGrant] = 
  ctx.registerResource[ClickhouseGrant, ClickhouseGrantArgs]("aiven:index/clickhouseGrant:ClickhouseGrant", name, args, opts)

