package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ClickhouseGrantArgs private(
  privilegeGrants: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.ClickhouseGrantPrivilegeGrantArgs]]],
  project: Output[String],
  role: Output[Option[String]],
  roleGrants: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.ClickhouseGrantRoleGrantArgs]]],
  serviceName: Output[String],
  user: Output[Option[String]]
) derives ArgsEncoder

object ClickhouseGrantArgs:
  def apply(
    privilegeGrants: Input.Optional[List[Input[besom.api.aiven.inputs.ClickhouseGrantPrivilegeGrantArgs]]] = None,
    project: Input[String],
    role: Input.Optional[String] = None,
    roleGrants: Input.Optional[List[Input[besom.api.aiven.inputs.ClickhouseGrantRoleGrantArgs]]] = None,
    serviceName: Input[String],
    user: Input.Optional[String] = None
  )(using Context): ClickhouseGrantArgs =
    new ClickhouseGrantArgs(
      privilegeGrants = privilegeGrants.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      role = role.asOptionOutput(isSecret = false),
      roleGrants = roleGrants.asOptionOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      user = user.asOptionOutput(isSecret = false)
    )
