package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class ClickhouseRole private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  project: Output[String],
  role: Output[String],
  serviceName: Output[String]
) extends CustomResource derives ResourceDecoder

object ClickhouseRole:
  given outputOps: {} with
    extension(output: Output[ClickhouseRole])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def project: Output[String] = output.flatMap(_.project)
      def role: Output[String] = output.flatMap(_.role)
      def serviceName: Output[String] = output.flatMap(_.serviceName)

def clickhouseRole(using ctx: Context)(
  name: NonEmptyString,
  args: ClickhouseRoleArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[ClickhouseRole] = 
  ctx.registerResource[ClickhouseRole, ClickhouseRoleArgs]("aiven:index/clickhouseRole:ClickhouseRole", name, args, opts)

