package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ClickhouseRoleArgs private(
  project: Output[String],
  role: Output[String],
  serviceName: Output[String]
) derives ArgsEncoder

object ClickhouseRoleArgs:
  def apply(
    project: Input[String],
    role: Input[String],
    serviceName: Input[String]
  )(using Context): ClickhouseRoleArgs =
    new ClickhouseRoleArgs(
      project = project.asOutput(isSecret = false),
      role = role.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false)
    )
