package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class ClickhouseUser private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  password: Output[String],
  project: Output[String],
  required: Output[Boolean],
  serviceName: Output[String],
  username: Output[String],
  uuid: Output[String]
) extends CustomResource derives ResourceDecoder

object ClickhouseUser:
  given outputOps: {} with
    extension(output: Output[ClickhouseUser])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def password: Output[String] = output.flatMap(_.password)
      def project: Output[String] = output.flatMap(_.project)
      def required: Output[Boolean] = output.flatMap(_.required)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def username: Output[String] = output.flatMap(_.username)
      def uuid: Output[String] = output.flatMap(_.uuid)

def clickhouseUser(using ctx: Context)(
  name: NonEmptyString,
  args: ClickhouseUserArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[ClickhouseUser] = 
  ctx.registerResource[ClickhouseUser, ClickhouseUserArgs]("aiven:index/clickhouseUser:ClickhouseUser", name, args, opts)

