package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ClickhouseUserArgs private(
  project: Output[String],
  serviceName: Output[String],
  username: Output[String]
) derives ArgsEncoder

object ClickhouseUserArgs:
  def apply(
    project: Input[String],
    serviceName: Input[String],
    username: Input[String]
  )(using Context): ClickhouseUserArgs =
    new ClickhouseUserArgs(
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      username = username.asOutput(isSecret = false)
    )
