package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class ConnectionPool private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  connectionUri: Output[String],
  databaseName: Output[String],
  poolMode: Output[Option[String]],
  poolName: Output[String],
  poolSize: Output[Option[Int]],
  project: Output[String],
  serviceName: Output[String],
  username: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object ConnectionPool:
  given outputOps: {} with
    extension(output: Output[ConnectionPool])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def connectionUri: Output[String] = output.flatMap(_.connectionUri)
      def databaseName: Output[String] = output.flatMap(_.databaseName)
      def poolMode: Output[Option[String]] = output.flatMap(_.poolMode)
      def poolName: Output[String] = output.flatMap(_.poolName)
      def poolSize: Output[Option[Int]] = output.flatMap(_.poolSize)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def username: Output[Option[String]] = output.flatMap(_.username)

def connectionPool(using ctx: Context)(
  name: NonEmptyString,
  args: ConnectionPoolArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[ConnectionPool] = 
  ctx.registerResource[ConnectionPool, ConnectionPoolArgs]("aiven:index/connectionPool:ConnectionPool", name, args, opts)

