package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ConnectionPoolArgs private(
  databaseName: Output[String],
  poolMode: Output[Option[String]],
  poolName: Output[String],
  poolSize: Output[Option[Int]],
  project: Output[String],
  serviceName: Output[String],
  username: Output[Option[String]]
) derives ArgsEncoder

object ConnectionPoolArgs:
  def apply(
    databaseName: Input[String],
    poolMode: Input.Optional[String] = None,
    poolName: Input[String],
    poolSize: Input.Optional[Int] = None,
    project: Input[String],
    serviceName: Input[String],
    username: Input.Optional[String] = None
  )(using Context): ConnectionPoolArgs =
    new ConnectionPoolArgs(
      databaseName = databaseName.asOutput(isSecret = false),
      poolMode = poolMode.asOptionOutput(isSecret = false),
      poolName = poolName.asOutput(isSecret = false),
      poolSize = poolSize.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      username = username.asOptionOutput(isSecret = false)
    )
