package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class FlinkApplication private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  applicationId: Output[String],
  createdAt: Output[String],
  createdBy: Output[String],
  name: Output[String],
  project: Output[String],
  serviceName: Output[String],
  updatedAt: Output[String],
  updatedBy: Output[String]
) extends CustomResource derives ResourceDecoder

object FlinkApplication:
  given outputOps: {} with
    extension(output: Output[FlinkApplication])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def applicationId: Output[String] = output.flatMap(_.applicationId)
      def createdAt: Output[String] = output.flatMap(_.createdAt)
      def createdBy: Output[String] = output.flatMap(_.createdBy)
      def name: Output[String] = output.flatMap(_.name)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def updatedAt: Output[String] = output.flatMap(_.updatedAt)
      def updatedBy: Output[String] = output.flatMap(_.updatedBy)

def flinkApplication(using ctx: Context)(
  name: NonEmptyString,
  args: FlinkApplicationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[FlinkApplication] = 
  ctx.registerResource[FlinkApplication, FlinkApplicationArgs]("aiven:index/flinkApplication:FlinkApplication", name, args, opts)

