package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class FlinkApplicationArgs private(
  name: Output[Option[String]],
  project: Output[String],
  serviceName: Output[String]
) derives ArgsEncoder

object FlinkApplicationArgs:
  def apply(
    name: Input.Optional[String] = None,
    project: Input[String],
    serviceName: Input[String]
  )(using Context): FlinkApplicationArgs =
    new FlinkApplicationArgs(
      name = name.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false)
    )
