package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class FlinkApplicationDeployment private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  applicationId: Output[String],
  createdAt: Output[String],
  createdBy: Output[String],
  parallelism: Output[Option[Int]],
  project: Output[String],
  restartEnabled: Output[Option[Boolean]],
  serviceName: Output[String],
  startingSavepoint: Output[Option[String]],
  versionId: Output[String]
) extends CustomResource derives ResourceDecoder

object FlinkApplicationDeployment:
  given outputOps: {} with
    extension(output: Output[FlinkApplicationDeployment])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def applicationId: Output[String] = output.flatMap(_.applicationId)
      def createdAt: Output[String] = output.flatMap(_.createdAt)
      def createdBy: Output[String] = output.flatMap(_.createdBy)
      def parallelism: Output[Option[Int]] = output.flatMap(_.parallelism)
      def project: Output[String] = output.flatMap(_.project)
      def restartEnabled: Output[Option[Boolean]] = output.flatMap(_.restartEnabled)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def startingSavepoint: Output[Option[String]] = output.flatMap(_.startingSavepoint)
      def versionId: Output[String] = output.flatMap(_.versionId)

def flinkApplicationDeployment(using ctx: Context)(
  name: NonEmptyString,
  args: FlinkApplicationDeploymentArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[FlinkApplicationDeployment] = 
  ctx.registerResource[FlinkApplicationDeployment, FlinkApplicationDeploymentArgs]("aiven:index/flinkApplicationDeployment:FlinkApplicationDeployment", name, args, opts)

