package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class FlinkApplicationDeploymentArgs private(
  applicationId: Output[String],
  parallelism: Output[Option[Int]],
  project: Output[String],
  restartEnabled: Output[Option[Boolean]],
  serviceName: Output[String],
  startingSavepoint: Output[Option[String]],
  versionId: Output[String]
) derives ArgsEncoder

object FlinkApplicationDeploymentArgs:
  def apply(
    applicationId: Input[String],
    parallelism: Input.Optional[Int] = None,
    project: Input[String],
    restartEnabled: Input.Optional[Boolean] = None,
    serviceName: Input[String],
    startingSavepoint: Input.Optional[String] = None,
    versionId: Input[String]
  )(using Context): FlinkApplicationDeploymentArgs =
    new FlinkApplicationDeploymentArgs(
      applicationId = applicationId.asOutput(isSecret = false),
      parallelism = parallelism.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      restartEnabled = restartEnabled.asOptionOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      startingSavepoint = startingSavepoint.asOptionOutput(isSecret = false),
      versionId = versionId.asOutput(isSecret = false)
    )
