package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class FlinkApplicationVersion private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  applicationId: Output[String],
  applicationVersionId: Output[String],
  createdAt: Output[String],
  createdBy: Output[String],
  project: Output[String],
  serviceName: Output[String],
  sink: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.FlinkApplicationVersionSink]]],
  sinks: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.FlinkApplicationVersionSink]]],
  source: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.FlinkApplicationVersionSource]]],
  sources: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.FlinkApplicationVersionSource]]],
  statement: Output[String],
  version: Output[Int]
) extends CustomResource derives ResourceDecoder

object FlinkApplicationVersion:
  given outputOps: {} with
    extension(output: Output[FlinkApplicationVersion])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def applicationId: Output[String] = output.flatMap(_.applicationId)
      def applicationVersionId: Output[String] = output.flatMap(_.applicationVersionId)
      def createdAt: Output[String] = output.flatMap(_.createdAt)
      def createdBy: Output[String] = output.flatMap(_.createdBy)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def sink: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.FlinkApplicationVersionSink]]] = output.flatMap(_.sink)
      def sinks: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.FlinkApplicationVersionSink]]] = output.flatMap(_.sinks)
      def source: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.FlinkApplicationVersionSource]]] = output.flatMap(_.source)
      def sources: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.FlinkApplicationVersionSource]]] = output.flatMap(_.sources)
      def statement: Output[String] = output.flatMap(_.statement)
      def version: Output[Int] = output.flatMap(_.version)

def flinkApplicationVersion(using ctx: Context)(
  name: NonEmptyString,
  args: FlinkApplicationVersionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[FlinkApplicationVersion] = 
  ctx.registerResource[FlinkApplicationVersion, FlinkApplicationVersionArgs]("aiven:index/flinkApplicationVersion:FlinkApplicationVersion", name, args, opts)

