package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class FlinkApplicationVersionArgs private(
  applicationId: Output[String],
  project: Output[String],
  serviceName: Output[String],
  sink: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.FlinkApplicationVersionSinkArgs]]],
  sinks: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.FlinkApplicationVersionSinkArgs]]],
  source: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.FlinkApplicationVersionSourceArgs]]],
  sources: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.FlinkApplicationVersionSourceArgs]]],
  statement: Output[String]
) derives ArgsEncoder

object FlinkApplicationVersionArgs:
  def apply(
    applicationId: Input[String],
    project: Input[String],
    serviceName: Input[String],
    sink: Input.Optional[List[Input[besom.api.aiven.inputs.FlinkApplicationVersionSinkArgs]]] = None,
    sinks: Input.Optional[List[Input[besom.api.aiven.inputs.FlinkApplicationVersionSinkArgs]]] = None,
    source: Input.Optional[List[Input[besom.api.aiven.inputs.FlinkApplicationVersionSourceArgs]]] = None,
    sources: Input.Optional[List[Input[besom.api.aiven.inputs.FlinkApplicationVersionSourceArgs]]] = None,
    statement: Input[String]
  )(using Context): FlinkApplicationVersionArgs =
    new FlinkApplicationVersionArgs(
      applicationId = applicationId.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      sink = sink.asOptionOutput(isSecret = false),
      sinks = sinks.asOptionOutput(isSecret = false),
      source = source.asOptionOutput(isSecret = false),
      sources = sources.asOptionOutput(isSecret = false),
      statement = statement.asOutput(isSecret = false)
    )
