package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class FlinkArgs private(
  additionalDiskSpace: Output[Option[String]],
  cloudName: Output[Option[String]],
  diskSpace: Output[Option[String]],
  flink: Output[Option[besom.api.aiven.inputs.FlinkFlinkArgs]],
  flinkUserConfig: Output[Option[besom.api.aiven.inputs.FlinkFlinkUserConfigArgs]],
  maintenanceWindowDow: Output[Option[String]],
  maintenanceWindowTime: Output[Option[String]],
  plan: Output[String],
  project: Output[String],
  projectVpcId: Output[Option[String]],
  serviceIntegrations: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.FlinkServiceIntegrationArgs]]],
  serviceName: Output[String],
  staticIps: Output[Option[scala.collection.immutable.List[String]]],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.FlinkTagArgs]]],
  terminationProtection: Output[Option[Boolean]]
) derives ArgsEncoder

object FlinkArgs:
  def apply(
    additionalDiskSpace: Input.Optional[String] = None,
    cloudName: Input.Optional[String] = None,
    diskSpace: Input.Optional[String] = None,
    flink: Input.Optional[besom.api.aiven.inputs.FlinkFlinkArgs] = None,
    flinkUserConfig: Input.Optional[besom.api.aiven.inputs.FlinkFlinkUserConfigArgs] = None,
    maintenanceWindowDow: Input.Optional[String] = None,
    maintenanceWindowTime: Input.Optional[String] = None,
    plan: Input[String],
    project: Input[String],
    projectVpcId: Input.Optional[String] = None,
    serviceIntegrations: Input.Optional[List[Input[besom.api.aiven.inputs.FlinkServiceIntegrationArgs]]] = None,
    serviceName: Input[String],
    staticIps: Input.Optional[List[Input[String]]] = None,
    tags: Input.Optional[List[Input[besom.api.aiven.inputs.FlinkTagArgs]]] = None,
    terminationProtection: Input.Optional[Boolean] = None
  )(using Context): FlinkArgs =
    new FlinkArgs(
      additionalDiskSpace = additionalDiskSpace.asOptionOutput(isSecret = false),
      cloudName = cloudName.asOptionOutput(isSecret = false),
      diskSpace = diskSpace.asOptionOutput(isSecret = false),
      flink = flink.asOptionOutput(isSecret = false),
      flinkUserConfig = flinkUserConfig.asOptionOutput(isSecret = false),
      maintenanceWindowDow = maintenanceWindowDow.asOptionOutput(isSecret = false),
      maintenanceWindowTime = maintenanceWindowTime.asOptionOutput(isSecret = false),
      plan = plan.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      projectVpcId = projectVpcId.asOptionOutput(isSecret = false),
      serviceIntegrations = serviceIntegrations.asOptionOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false),
      tags = tags.asOptionOutput(isSecret = false),
      terminationProtection = terminationProtection.asOptionOutput(isSecret = false)
    )
