package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class GcpPrivatelink private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  googleServiceAttachment: Output[String],
  message: Output[String],
  project: Output[String],
  serviceName: Output[String],
  state: Output[String]
) extends CustomResource derives ResourceDecoder

object GcpPrivatelink:
  given outputOps: {} with
    extension(output: Output[GcpPrivatelink])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def googleServiceAttachment: Output[String] = output.flatMap(_.googleServiceAttachment)
      def message: Output[String] = output.flatMap(_.message)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def state: Output[String] = output.flatMap(_.state)

def gcpPrivatelink(using ctx: Context)(
  name: NonEmptyString,
  args: GcpPrivatelinkArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[GcpPrivatelink] = 
  ctx.registerResource[GcpPrivatelink, GcpPrivatelinkArgs]("aiven:index/gcpPrivatelink:GcpPrivatelink", name, args, opts)

