package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class GcpPrivatelinkArgs private(
  project: Output[String],
  serviceName: Output[String]
) derives ArgsEncoder

object GcpPrivatelinkArgs:
  def apply(
    project: Input[String],
    serviceName: Input[String]
  )(using Context): GcpPrivatelinkArgs =
    new GcpPrivatelinkArgs(
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false)
    )
