package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class GcpPrivatelinkConnectionApproval private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  privatelinkConnectionId: Output[String],
  project: Output[String],
  pscConnectionId: Output[String],
  serviceName: Output[String],
  state: Output[String],
  userIpAddress: Output[String]
) extends CustomResource derives ResourceDecoder

object GcpPrivatelinkConnectionApproval:
  given outputOps: {} with
    extension(output: Output[GcpPrivatelinkConnectionApproval])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def privatelinkConnectionId: Output[String] = output.flatMap(_.privatelinkConnectionId)
      def project: Output[String] = output.flatMap(_.project)
      def pscConnectionId: Output[String] = output.flatMap(_.pscConnectionId)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def state: Output[String] = output.flatMap(_.state)
      def userIpAddress: Output[String] = output.flatMap(_.userIpAddress)

def gcpPrivatelinkConnectionApproval(using ctx: Context)(
  name: NonEmptyString,
  args: GcpPrivatelinkConnectionApprovalArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[GcpPrivatelinkConnectionApproval] = 
  ctx.registerResource[GcpPrivatelinkConnectionApproval, GcpPrivatelinkConnectionApprovalArgs]("aiven:index/gcpPrivatelinkConnectionApproval:GcpPrivatelinkConnectionApproval", name, args, opts)

