package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class GcpVpcPeeringConnection private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  gcpProjectId: Output[String],
  peerVpc: Output[String],
  selfLink: Output[String],
  state: Output[String],
  stateInfo: Output[scala.Predef.Map[String, besom.types.PulumiAny]],
  vpcId: Output[String]
) extends CustomResource derives ResourceDecoder

object GcpVpcPeeringConnection:
  given outputOps: {} with
    extension(output: Output[GcpVpcPeeringConnection])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def gcpProjectId: Output[String] = output.flatMap(_.gcpProjectId)
      def peerVpc: Output[String] = output.flatMap(_.peerVpc)
      def selfLink: Output[String] = output.flatMap(_.selfLink)
      def state: Output[String] = output.flatMap(_.state)
      def stateInfo: Output[scala.Predef.Map[String, besom.types.PulumiAny]] = output.flatMap(_.stateInfo)
      def vpcId: Output[String] = output.flatMap(_.vpcId)

def gcpVpcPeeringConnection(using ctx: Context)(
  name: NonEmptyString,
  args: GcpVpcPeeringConnectionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[GcpVpcPeeringConnection] = 
  ctx.registerResource[GcpVpcPeeringConnection, GcpVpcPeeringConnectionArgs]("aiven:index/gcpVpcPeeringConnection:GcpVpcPeeringConnection", name, args, opts)

