package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class GcpVpcPeeringConnectionArgs private(
  gcpProjectId: Output[String],
  peerVpc: Output[String],
  vpcId: Output[String]
) derives ArgsEncoder

object GcpVpcPeeringConnectionArgs:
  def apply(
    gcpProjectId: Input[String],
    peerVpc: Input[String],
    vpcId: Input[String]
  )(using Context): GcpVpcPeeringConnectionArgs =
    new GcpVpcPeeringConnectionArgs(
      gcpProjectId = gcpProjectId.asOutput(isSecret = false),
      peerVpc = peerVpc.asOutput(isSecret = false),
      vpcId = vpcId.asOutput(isSecret = false)
    )
