package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class GrafanaArgs private(
  additionalDiskSpace: Output[Option[String]],
  cloudName: Output[Option[String]],
  diskSpace: Output[Option[String]],
  grafanaUserConfig: Output[Option[besom.api.aiven.inputs.GrafanaGrafanaUserConfigArgs]],
  maintenanceWindowDow: Output[Option[String]],
  maintenanceWindowTime: Output[Option[String]],
  plan: Output[String],
  project: Output[String],
  projectVpcId: Output[Option[String]],
  serviceIntegrations: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.GrafanaServiceIntegrationArgs]]],
  serviceName: Output[Option[String]],
  staticIps: Output[Option[scala.collection.immutable.List[String]]],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.GrafanaTagArgs]]],
  terminationProtection: Output[Option[Boolean]]
) derives ArgsEncoder

object GrafanaArgs:
  def apply(
    additionalDiskSpace: Input.Optional[String] = None,
    cloudName: Input.Optional[String] = None,
    diskSpace: Input.Optional[String] = None,
    grafanaUserConfig: Input.Optional[besom.api.aiven.inputs.GrafanaGrafanaUserConfigArgs] = None,
    maintenanceWindowDow: Input.Optional[String] = None,
    maintenanceWindowTime: Input.Optional[String] = None,
    plan: Input[String],
    project: Input[String],
    projectVpcId: Input.Optional[String] = None,
    serviceIntegrations: Input.Optional[List[Input[besom.api.aiven.inputs.GrafanaServiceIntegrationArgs]]] = None,
    serviceName: Input.Optional[String] = None,
    staticIps: Input.Optional[List[Input[String]]] = None,
    tags: Input.Optional[List[Input[besom.api.aiven.inputs.GrafanaTagArgs]]] = None,
    terminationProtection: Input.Optional[Boolean] = None
  )(using Context): GrafanaArgs =
    new GrafanaArgs(
      additionalDiskSpace = additionalDiskSpace.asOptionOutput(isSecret = false),
      cloudName = cloudName.asOptionOutput(isSecret = false),
      diskSpace = diskSpace.asOptionOutput(isSecret = false),
      grafanaUserConfig = grafanaUserConfig.asOptionOutput(isSecret = false),
      maintenanceWindowDow = maintenanceWindowDow.asOptionOutput(isSecret = false),
      maintenanceWindowTime = maintenanceWindowTime.asOptionOutput(isSecret = false),
      plan = plan.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      projectVpcId = projectVpcId.asOptionOutput(isSecret = false),
      serviceIntegrations = serviceIntegrations.asOptionOutput(isSecret = false),
      serviceName = serviceName.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false),
      tags = tags.asOptionOutput(isSecret = false),
      terminationProtection = terminationProtection.asOptionOutput(isSecret = false)
    )
