package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class InfluxdbDatabase private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  databaseName: Output[String],
  project: Output[String],
  serviceName: Output[String],
  terminationProtection: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object InfluxdbDatabase:
  given outputOps: {} with
    extension(output: Output[InfluxdbDatabase])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def databaseName: Output[String] = output.flatMap(_.databaseName)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def terminationProtection: Output[Option[Boolean]] = output.flatMap(_.terminationProtection)

def influxdbDatabase(using ctx: Context)(
  name: NonEmptyString,
  args: InfluxdbDatabaseArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[InfluxdbDatabase] = 
  ctx.registerResource[InfluxdbDatabase, InfluxdbDatabaseArgs]("aiven:index/influxdbDatabase:InfluxdbDatabase", name, args, opts)

