package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class InfluxdbDatabaseArgs private(
  databaseName: Output[String],
  project: Output[String],
  serviceName: Output[String],
  terminationProtection: Output[Option[Boolean]]
) derives ArgsEncoder

object InfluxdbDatabaseArgs:
  def apply(
    databaseName: Input[String],
    project: Input[String],
    serviceName: Input[String],
    terminationProtection: Input.Optional[Boolean] = None
  )(using Context): InfluxdbDatabaseArgs =
    new InfluxdbDatabaseArgs(
      databaseName = databaseName.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      terminationProtection = terminationProtection.asOptionOutput(isSecret = false)
    )
