package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class InfluxdbUserArgs private(
  password: Output[Option[String]],
  project: Output[String],
  serviceName: Output[String],
  username: Output[String]
) derives ArgsEncoder

object InfluxdbUserArgs:
  def apply(
    password: Input.Optional[String] = None,
    project: Input[String],
    serviceName: Input[String],
    username: Input[String]
  )(using Context): InfluxdbUserArgs =
    new InfluxdbUserArgs(
      password = password.asOptionOutput(isSecret = true),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      username = username.asOutput(isSecret = false)
    )
