package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class KafkaAcl private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  aclId: Output[String],
  permission: Output[String],
  project: Output[String],
  serviceName: Output[String],
  topic: Output[String],
  username: Output[String]
) extends CustomResource derives ResourceDecoder

object KafkaAcl:
  given outputOps: {} with
    extension(output: Output[KafkaAcl])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def aclId: Output[String] = output.flatMap(_.aclId)
      def permission: Output[String] = output.flatMap(_.permission)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def topic: Output[String] = output.flatMap(_.topic)
      def username: Output[String] = output.flatMap(_.username)

def kafkaAcl(using ctx: Context)(
  name: NonEmptyString,
  args: KafkaAclArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[KafkaAcl] = 
  ctx.registerResource[KafkaAcl, KafkaAclArgs]("aiven:index/kafkaAcl:KafkaAcl", name, args, opts)

