package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class KafkaAclArgs private(
  permission: Output[String],
  project: Output[String],
  serviceName: Output[String],
  topic: Output[String],
  username: Output[String]
) derives ArgsEncoder

object KafkaAclArgs:
  def apply(
    permission: Input[String],
    project: Input[String],
    serviceName: Input[String],
    topic: Input[String],
    username: Input[String]
  )(using Context): KafkaAclArgs =
    new KafkaAclArgs(
      permission = permission.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      topic = topic.asOutput(isSecret = false),
      username = username.asOutput(isSecret = false)
    )
