package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class KafkaArgs private(
  additionalDiskSpace: Output[Option[String]],
  cloudName: Output[Option[String]],
  defaultAcl: Output[Option[Boolean]],
  diskSpace: Output[Option[String]],
  kafkaUserConfig: Output[Option[besom.api.aiven.inputs.KafkaKafkaUserConfigArgs]],
  karapace: Output[Option[Boolean]],
  maintenanceWindowDow: Output[Option[String]],
  maintenanceWindowTime: Output[Option[String]],
  plan: Output[String],
  project: Output[String],
  projectVpcId: Output[Option[String]],
  serviceIntegrations: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.KafkaServiceIntegrationArgs]]],
  serviceName: Output[String],
  staticIps: Output[Option[scala.collection.immutable.List[String]]],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.KafkaTagArgs]]],
  terminationProtection: Output[Option[Boolean]]
) derives ArgsEncoder

object KafkaArgs:
  def apply(
    additionalDiskSpace: Input.Optional[String] = None,
    cloudName: Input.Optional[String] = None,
    defaultAcl: Input.Optional[Boolean] = None,
    diskSpace: Input.Optional[String] = None,
    kafkaUserConfig: Input.Optional[besom.api.aiven.inputs.KafkaKafkaUserConfigArgs] = None,
    karapace: Input.Optional[Boolean] = None,
    maintenanceWindowDow: Input.Optional[String] = None,
    maintenanceWindowTime: Input.Optional[String] = None,
    plan: Input[String],
    project: Input[String],
    projectVpcId: Input.Optional[String] = None,
    serviceIntegrations: Input.Optional[List[Input[besom.api.aiven.inputs.KafkaServiceIntegrationArgs]]] = None,
    serviceName: Input[String],
    staticIps: Input.Optional[List[Input[String]]] = None,
    tags: Input.Optional[List[Input[besom.api.aiven.inputs.KafkaTagArgs]]] = None,
    terminationProtection: Input.Optional[Boolean] = None
  )(using Context): KafkaArgs =
    new KafkaArgs(
      additionalDiskSpace = additionalDiskSpace.asOptionOutput(isSecret = false),
      cloudName = cloudName.asOptionOutput(isSecret = false),
      defaultAcl = defaultAcl.asOptionOutput(isSecret = false),
      diskSpace = diskSpace.asOptionOutput(isSecret = false),
      kafkaUserConfig = kafkaUserConfig.asOptionOutput(isSecret = false),
      karapace = karapace.asOptionOutput(isSecret = false),
      maintenanceWindowDow = maintenanceWindowDow.asOptionOutput(isSecret = false),
      maintenanceWindowTime = maintenanceWindowTime.asOptionOutput(isSecret = false),
      plan = plan.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      projectVpcId = projectVpcId.asOptionOutput(isSecret = false),
      serviceIntegrations = serviceIntegrations.asOptionOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false),
      tags = tags.asOptionOutput(isSecret = false),
      terminationProtection = terminationProtection.asOptionOutput(isSecret = false)
    )
