package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class KafkaConnector private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  config: Output[scala.Predef.Map[String, String]],
  connectorName: Output[String],
  pluginAuthor: Output[String],
  pluginClass: Output[String],
  pluginDocUrl: Output[String],
  pluginTitle: Output[String],
  pluginType: Output[String],
  pluginVersion: Output[String],
  project: Output[String],
  serviceName: Output[String],
  tasks: Output[scala.collection.immutable.List[besom.api.aiven.outputs.KafkaConnectorTask]]
) extends CustomResource derives ResourceDecoder

object KafkaConnector:
  given outputOps: {} with
    extension(output: Output[KafkaConnector])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def config: Output[scala.Predef.Map[String, String]] = output.flatMap(_.config)
      def connectorName: Output[String] = output.flatMap(_.connectorName)
      def pluginAuthor: Output[String] = output.flatMap(_.pluginAuthor)
      def pluginClass: Output[String] = output.flatMap(_.pluginClass)
      def pluginDocUrl: Output[String] = output.flatMap(_.pluginDocUrl)
      def pluginTitle: Output[String] = output.flatMap(_.pluginTitle)
      def pluginType: Output[String] = output.flatMap(_.pluginType)
      def pluginVersion: Output[String] = output.flatMap(_.pluginVersion)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def tasks: Output[scala.collection.immutable.List[besom.api.aiven.outputs.KafkaConnectorTask]] = output.flatMap(_.tasks)

def kafkaConnector(using ctx: Context)(
  name: NonEmptyString,
  args: KafkaConnectorArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[KafkaConnector] = 
  ctx.registerResource[KafkaConnector, KafkaConnectorArgs]("aiven:index/kafkaConnector:KafkaConnector", name, args, opts)

